<?php 
class cf7_group_field {
	function __construct()
	{
		add_action( 'wpcf7_init', array($this,'add_tag') );
		add_action( 'wpcf7_admin_init', array($this,'wpcf7_add_tag_generator'), 10 );
		add_filter( 'wpcf7_contact_form_properties', array($this,'custom_group'), 10, 2 );
	}
	function add_tag()
	{
		wpcf7_add_form_tag( array( 'group',  ),array($this,'tag_handler'));
	}
	function tag_handler($tag) {
		$tag = new WPCF7_FormTag($tag);
        return $tag->content;
	}
	function wpcf7_add_tag_generator() {
		$tag_generator = WPCF7_TagGenerator::get_instance();
		$tag_generator->add( 'group', __( 'Group logic', 'contact-form-7-conditional-logic' ),
			array($this,'wpcf7_tag_generator') );
	}
	function wpcf7_tag_generator( $contact_form, $args = '' ) {
		$args = wp_parse_args( $args, array() );

		$description = __( "Generate a form-tag for a group. For more details, see %s.", 'contact-form-7' );

	?>
	<div class="control-box">
	<fieldset>
	<legend><?php echo sprintf( esc_html( $description ), $desc_link ); ?></legend>

	<table class="form-table">
	<tbody>
		<tr>
		<th scope="row"><label for="<?php echo esc_attr( $args['content'] . '-name' ); ?>"><?php echo esc_html( __( 'Name', 'contact-form-7' ) ); ?></label></th>
		<td><input type="text" name="name" class="tg-name oneline" id="<?php echo esc_attr( $args['content'] . '-name' ); ?>" /></td>
		</tr>
	</tbody>
	</table>
	</fieldset>
	</div>

	<div class="insert-box">
		<input type="text" name="group" class="tag code" readonly="readonly" onfocus="this.select()" />

		<div class="submitbox">
		<input type="button" class="button button-primary insert-tag" value="<?php echo esc_attr( __( 'Insert Tag', 'contact-form-7' ) ); ?>" />
		</div>

		<br class="clear" />
	</div>
	<?php
	}
	function custom_group($properties, $wpcf7form) {
	    if (!is_admin() || (defined('DOING_AJAX') && DOING_AJAX)) { 
	        $form = preg_replace( array(
	            '/\[group\s*\]/s', 
	            '/\[group\s+([^\s\]]*)\s*([^\]]*)\]/s', 
	            '/\[\/group\]/s'
	        ),  array(
	            '<div class="cf7-group">',
	            '<div id="$1" class="cf7-group">',
	            '</div>'
	        ), $properties['form'] );
	        
	        $properties['form'] = $form;
	    }
	    return $properties;
	}
}
new cf7_group_field;