<?php
namespace BooklyPackages\Backend\Components\Dialogs\Package;

use Bookly\Lib as BooklyLib;

/**
 * Class Dialog
 * @package BooklyPackages\Backend\Components\Dialogs\Package
 */
class Dialog extends BooklyLib\Base\Component
{
    public static function render()
    {
        self::enqueueStyles( array(
            'alias' => array( 'bookly-backend-globals', ),
        ) );

        self::enqueueScripts( array(
            'bookly' => array( 'backend/resources/js/select2.min.js' => array( 'bookly-backend-globals' ), ),
            'module' => array( 'js/package.js' => array( 'bookly-select2.min.js' ), ),
        ) );

        wp_localize_script( 'bookly-package.js', 'BooklyL10nPackageDialog', array(
            'csrf_token' => BooklyLib\Utils\Common::getCsrfToken(),
            'datePicker' => BooklyLib\Utils\DateTime::datePickerOptions(),
            'send_notifications' => get_user_meta( get_current_user_id(), 'bookly_packages_form_send_notifications', true ),
            'l10n' => array(
                'edit_package' => __( 'Edit package', 'bookly' ),
                'new_package' => __( 'New package', 'bookly' ),
                'send_notifications' => __( 'Send notifications', 'bookly' ),
                'provider' => __( 'Provider', 'bookly' ),
                'provider_description' => __( 'Select service provider to see the packages provided. Or select unassigned package to see packages with no particular provider.', 'bookly' ),
                'package'=> __( 'Package', 'bookly' ),
                'select_a_package' => __( '-- Select a package --', 'bookly' ),
                'location' => __( 'Location', 'bookly' ),
                'customer' => __( 'Customer', 'bookly' ),
                'remove_customer' => __( 'Remove customer', 'bookly' ),
                'search_customer' => __( '-- Search customer --', 'bookly' ),
                'new_customer' => __( 'New customer', 'bookly' ),
                'no_result_found' => __( 'No result found', 'bookly' ),
                'searching' => __( 'Searching', 'bookly' ),
                'save' => __( 'Save', 'bookly' ),
                'save_and_schedule' => __( 'Save & schedule', 'bookly' ),
                'cancel' => __( 'Cancel', 'bookly' ),
                'internal_note' => __( 'Internal note', 'bookly' ),
                'notices' => array(
                    'service_required' => __( 'Please select a package', 'bookly' ),
                    'location_service_combination' => __( 'Incorrect location and package combination', 'bookly' ),
                    'customer_required' => __( 'Please select a customer', 'bookly' ),
                ),
            ),
        ) );

        self::renderTemplate( 'modal' );
    }
}