<?php
namespace BooklyPackages\Frontend\Modules\CustomerPackages;

use Bookly\Lib as BooklyLib;
use BooklyPackages\Lib;

/**
 * Class ShortCode
 * @package BooklyPackages\Frontend\Modules\CustomerPackages
 */
class ShortCode extends BooklyLib\Base\Component
{
    /**
     * Init component.
     */
    public static function init()
    {
        // Register shortcodes.
        add_shortcode( 'bookly-packages-list', array( __CLASS__, 'render' ) );

        // Assets.
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkStyles' ) );
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkScripts' ) );
    }

    /**
     * Link styles.
     */
    public static function linkStyles()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-packages-list' )
        ) {
            self::enqueueStyles(array(
                'bookly' => array( 'backend/resources/css/fontawesome-all.min.css' => array( 'bookly-backend-globals' ) ),
                'module' => array( 'css/customer-packages.css' => array( 'bookly-bootstrap.min.css' ) )
            ) );
        }
    }

    /**
     * Link scripts.
     */
    public static function linkScripts()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-packages-list' )
        ) {
            self::enqueueScripts( array(
                'bookly' => array( 'backend/resources/js/range-tools.js' => array( 'bookly-backend-globals' ) ),
                'module' => array( 'js/customer-packages.js' => array( 'bookly-range-tools.js' ) ),
            ) );

            wp_localize_script( 'bookly-customer-packages.js', 'BooklyCustomerPackagesL10n', array(
                'zeroRecords'          => __( 'No packages for selected period and criteria.', 'bookly' ),
                'scheduleAppointments' => __( 'Package schedule', 'bookly' ),
                'processing'           => __( 'Processing...', 'bookly' ),
                'useClientTimeZone'    => BooklyLib\Config::useClientTimeZone(),
                'csrf_token'           => BooklyLib\Utils\Common::getCsrfToken(),
            ) );
        }
    }

    /**
     * @param $attributes
     * @return string
     */
    public static function render( $attributes )
    {
        // Disable caching.
        BooklyLib\Utils\Common::noCache();

        $customer = new BooklyLib\Entities\Customer();
        $customer->loadBy( array( 'wp_user_id' => get_current_user_id() ) );
        if ( $customer->getId() ) {
            // Prepare URL for AJAX requests.
            $ajax_url = admin_url( 'admin-ajax.php' );

            $form_id = uniqid();

            return self::renderTemplate( 'short_code', compact( 'ajax_url', 'customer', 'form_id' ), false );
        } else {
            return self::renderTemplate( 'permission', array(), false );
        }
    }
}