<?php
namespace BooklyPackages\Backend\Modules\Services\ProxyProviders;

use Bookly\Lib as BooklyLib;
use Bookly\Backend\Modules\Services\Proxy;

/**
 * Class Shared
 * @package BooklyPackages\Backend\Modules\Services\ProxyProviders
 */
class Shared extends Proxy\Shared
{
    /**
     * @inheritDoc
     */
    public static function prepareServiceColors( array $colors, $service_id, $service_type )
    {
        if ( $service_type == BooklyLib\Entities\Service::TYPE_PACKAGE ) {
            $row = BooklyLib\Entities\SubService::query( 'ss' )
                ->select( 's.color' )
                ->innerJoin( 'Service', 's', 'ss.sub_service_id = s.id' )
                ->where( 'ss.service_id', $service_id )
                ->fetchRow();
            $color  = isset( $row['color'] ) ? $row['color'] : '-1';
            $colors = array( $color, $color, $color );
        }

        return $colors;
    }

    /**
     * @inheritDoc
     */
    public static function prepareServiceIcons( $icons )
    {
        $icons[ BooklyLib\Entities\Service::TYPE_PACKAGE ] = 'far fa-calendar-alt';

        return $icons;
    }

    /**
     * @inheritDoc
     */
    public static function prepareServiceTypes( $types )
    {
        $types[ BooklyLib\Entities\Service::TYPE_PACKAGE ] = __( 'Package', 'bookly' );

        return $types;
    }

    /**
     * Delete records for packages if service has been deleted
     *
     * @param BooklyLib\Entities\Service $service
     */
    public static function serviceDeleted( $service )
    {
        if ( $service->getType() == BooklyLib\Entities\Service::TYPE_SIMPLE ) {
            $packages = BooklyLib\Entities\SubService::query( 'ss' )
                ->select( 's.id' )
                ->innerJoin( 'Service', 's', 'ss.service_id = s.id' )
                ->where( 'ss.sub_service_id', $service->getId() )
                ->where( 's.type', BooklyLib\Entities\Service::TYPE_PACKAGE )
                ->fetchArray();
            // Delete packages & staff-services related to service.
            BooklyLib\Entities\Service::query()
                ->delete()
                ->whereIn( 'id', array_map( function ( $packages ) { return $packages['id']; }, $packages ) )
                ->execute();
        }
    }
}